/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo2.handler;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.pipo2.AbstractElementHandler;
import org.adempiere.pipo2.Element;
import org.adempiere.pipo2.PIPOContext;
import org.adempiere.pipo2.PackOut;
import org.adempiere.pipo2.PoExporter;
import org.adempiere.pipo2.PoFiller;
import org.adempiere.pipo2.exception.POSaveFailedException;
import org.adempiere.pipo2.handler.CommonTranslationHandler;
import org.compiere.model.M_Element;
import org.compiere.model.PO;
import org.compiere.model.X_AD_Element;
import org.compiere.model.X_AD_Package_Imp_Detail;
import org.compiere.util.Env;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class AdElementHandler
extends AbstractElementHandler {
    private List<Integer> processedElements = new ArrayList<Integer>();
    private static final String AD_ELEMENT = "AD_Element";

    public void startElement(PIPOContext ctx, Element element) throws SAXException {
        String action = null;
        String entitytype = this.getStringValue(element, "EntityType");
        if (this.isProcessElement(ctx.ctx, entitytype)) {
            M_Element mElement = (M_Element)this.findPO(ctx, element);
            if (mElement == null) {
                mElement = new M_Element(ctx.ctx, 0, this.getTrxName(ctx));
            }
            List excludes = this.defaultExcludeList(AD_ELEMENT);
            if (this.processedElements.contains(mElement.getAD_Element_ID())) {
                element.skip = true;
                return;
            }
            PoFiller pf = new PoFiller(ctx, (PO)mElement, element, (AbstractElementHandler)this);
            List notfounds = pf.autoFill(excludes);
            if (notfounds.size() > 0) {
                element.defer = true;
                element.unresolved = notfounds.toString();
                return;
            }
            if (mElement.is_new() || mElement.is_Changed()) {
                X_AD_Package_Imp_Detail impDetail = this.createImportDetail(ctx, element.qName, AD_ELEMENT, 276);
                if (!mElement.is_new()) {
                    this.backupRecord(ctx, impDetail.getAD_Package_Imp_Detail_ID(), AD_ELEMENT, (PO)mElement);
                    action = "Update";
                } else {
                    action = "New";
                }
                if (mElement.save(this.getTrxName(ctx))) {
                    this.logImportDetail(ctx, impDetail, 1, mElement.getName(), mElement.get_ID(), action);
                    this.processedElements.add(mElement.getAD_Element_ID());
                } else {
                    this.logImportDetail(ctx, impDetail, 0, mElement.getName(), mElement.get_ID(), action);
                    throw new POSaveFailedException("Failed to save Element " + mElement.getName());
                }
            }
            element.recordId = mElement.getAD_Element_ID();
        } else {
            element.skip = true;
        }
    }

    public void endElement(PIPOContext ctx, Element element) throws SAXException {
    }

    protected void create(PIPOContext ctx, TransformerHandler document) throws SAXException {
        block4: {
            int adElement_id = Env.getContextAsInt((Properties)ctx.ctx, (String)"AD_Element_ID");
            if (ctx.packOut.isExported("AD_Element_ID|" + adElement_id)) {
                return;
            }
            X_AD_Element mAdElement = new X_AD_Element(ctx.ctx, adElement_id, null);
            if (!this.isPackOutElement(ctx, (PO)mAdElement)) {
                return;
            }
            this.verifyPackOutRequirement((PO)mAdElement);
            AttributesImpl atts = new AttributesImpl();
            this.addTypeName(atts, "table");
            document.startElement("", "", AD_ELEMENT, atts);
            this.createAdElementBinding(ctx, document, mAdElement);
            PackOut packOut = ctx.packOut;
            packOut.getCtx().ctx.put("Table_Name", AD_ELEMENT);
            try {
                new CommonTranslationHandler().packOut(packOut, document, null, mAdElement.get_ID());
            }
            catch (Exception e) {
                if (!this.log.isLoggable(Level.INFO)) break block4;
                this.log.info(e.toString());
            }
        }
        document.endElement("", "", AD_ELEMENT);
    }

    private void createAdElementBinding(PIPOContext ctx, TransformerHandler document, X_AD_Element m_AdElement) {
        PoExporter filler = new PoExporter(ctx, document, (PO)m_AdElement);
        if (m_AdElement.getAD_Element_ID() <= 999999) {
            filler.add("AD_Element_ID", new AttributesImpl());
        }
        List excludes = this.defaultExcludeList(AD_ELEMENT);
        filler.export(excludes);
    }

    public void packOut(PackOut packout, TransformerHandler packoutHandler, TransformerHandler docHandler, int recordId) throws Exception {
        Env.setContext((Properties)packout.getCtx().ctx, (String)"AD_Element_ID", (int)recordId);
        this.create(packout.getCtx(), packoutHandler);
        packout.getCtx().ctx.remove("AD_Element_ID");
    }
}

